/*
 * Decompiled with CFR 0.152.
 */
package com.djinfinite.manors_bounty.items;

import com.djinfinite.manors_bounty.items.FoodEffect;
import com.djinfinite.manors_bounty.items.FoodEffectType;
import com.djinfinite.manors_bounty.items.FoodType;
import com.djinfinite.manors_bounty.items.IFoodItem;
import com.djinfinite.manors_bounty.registries.ModMobEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class Peach
extends Item
implements IFoodItem {
    protected Peach(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public FoodType getFoodType() {
        return FoodType.PEACH;
    }

    public static class Juice
    extends Peach {
        public Juice() {
            super(new Item.Properties().m_41487_(16).m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.1f).m_38765_().m_38767_()));
        }

        @NotNull
        public UseAnim m_6164_(@NotNull ItemStack itemstack) {
            return UseAnim.DRINK;
        }

        @Override
        public ItemStack usedWhenNotInCooldown(Level level, Player player, ItemStack itemStack) {
            if (level.m_5776_()) {
                return itemStack;
            }
            if (this.getFoodEffect().apply((LivingEntity)player)) {
                this.cooldown(player, this);
            }
            return this.returnCup(player, itemStack);
        }

        @Override
        public ItemStack usedWhenInCooldown(Level level, Player player, ItemStack itemStack) {
            return this.returnCup(player, itemStack);
        }

        @Override
        public FoodEffectType getFoodEffectType() {
            return FoodEffectType.B;
        }

        @Override
        public FoodEffect getFoodEffect() {
            return FoodEffect.B.of().addEffect((MobEffect)ModMobEffects.ROSA_HEDGE.get(), 70.0);
        }
    }

    public static class Sliced
    extends Peach {
        public Sliced() {
            super(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.3f).m_38767_()));
        }

        @Override
        public FoodEffectType getFoodEffectType() {
            return FoodEffectType.A;
        }

        @Override
        public FoodEffect getFoodEffect() {
            return FoodEffect.A.of().addEffect((MobEffect)ModMobEffects.ROSA_HEDGE.get(), 33.0);
        }
    }

    public static class Self
    extends Peach {
        public Self() {
            super(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(5).m_38758_(0.3f).m_38767_()));
        }

        @Override
        public FoodEffectType getFoodEffectType() {
            return FoodEffectType.A;
        }

        @Override
        public FoodEffect getFoodEffect() {
            return FoodEffect.A.of().addEffect((MobEffect)ModMobEffects.ROSA_HEDGE.get());
        }
    }
}

